///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DOSEND_CPP
#define _DOSEND_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"

#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::DoSend(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::DoSend.\n");
    #endif

    int Result = 0;

	if( icSendBufSz[iClient] <= 0)
    {
        return false;
    }

    if(bcConnected[iClient] && !bcDisconnect[iClient])
    {
        Result = SendDataEx(iClient, scSendBuf[iClient], icSendBufSz[iClient]);
    }
    else return false;

    if(Result == SOCKET_ERROR)
	{
        int LastError = WSAGetLastError();
        if(LastError == WSAEWOULDBLOCK || LastError == WSAEINPROGRESS)
        {
            return false;
        }

    	bcDisconnect[iClient] = true;
		return false;
	}
    else if(Result == 0)
	{
		bcDisconnect[iClient] = true;
		return false;
	}

    icSendBufSz[iClient] = 0;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

